/*
 * Decompiled with CFR 0.152.
 */
package com.wouterdegeus.testbank._javafxcomponents.flipcard_listview;

import com.wouterdegeus.testbank.Testbank;
import com.wouterdegeus.testbank._javafxcomponents.flipcard_listview.FlipCell;
import com.wouterdegeus.testbank.domain.FlipCard;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;

public class FlipCardListViewController
implements Initializable {
    @FXML
    private ListView<FlipCard> flipCardListView;
    private Testbank.EventRegistry eventRegistry;
    private Consumer<FlipCard> onFlipCardSelected;

    public void setFlipCards(ObservableList<FlipCard> flipCards) {
        this.flipCardListView.setItems(flipCards);
        this.flipCardListView.setCellFactory(lv -> new FlipCell());
    }

    public void setOnFlipCardSelected(Consumer<FlipCard> listener) {
        this.onFlipCardSelected = listener;
    }

    private void handleSelection(MouseEvent event) {
        this.eventRegistry.emitEvent(event);
        FlipCard selected = (FlipCard)this.flipCardListView.getSelectionModel().getSelectedItem();
        if (selected != null && this.onFlipCardSelected != null) {
            this.onFlipCardSelected.accept(selected);
        }
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.eventRegistry = Testbank.getInstance();
        this.flipCardListView.setOnMouseClicked(this::handleSelection);
    }
}

