/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application.preferences;

import com.sun.javafx.application.preferences.ChangedValue;
import com.sun.javafx.application.preferences.PreferenceMapping;
import com.sun.javafx.application.preferences.PreferenceProperties;
import com.sun.javafx.binding.MapExpressionHelper;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.ColorScheme;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.MapChangeListener;
import javafx.scene.paint.Color;

public final class PlatformPreferences
extends AbstractMap<String, Object>
implements Platform.Preferences {
    private final Map<String, Class<?>> platformKeys = new HashMap();
    private final Map<String, PreferenceMapping<?, ?>> platformKeyMappings = new HashMap();
    private final Map<String, Object> effectivePreferences = new HashMap<String, Object>();
    private final Map<String, Object> unmodifiableEffectivePreferences = Collections.unmodifiableMap(this.effectivePreferences);
    private final PreferenceProperties properties = new PreferenceProperties(this);
    private final List<InvalidationListener> invalidationListeners = new CopyOnWriteArrayList<InvalidationListener>();
    private final List<MapChangeListener<? super String, Object>> mapChangeListeners = new CopyOnWriteArrayList<MapChangeListener<? super String, Object>>();

    public void initialize(Map<String, Class<?>> map, Map<String, PreferenceMapping<?, ?>> map2) {
        this.platformKeys.putAll(map);
        this.platformKeyMappings.putAll(map2);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.unmodifiableEffectivePreferences.entrySet();
    }

    @Override
    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.invalidationListeners.add(invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.invalidationListeners.remove(invalidationListener);
    }

    @Override
    public void addListener(MapChangeListener<? super String, ? super Object> mapChangeListener) {
        this.mapChangeListeners.add(mapChangeListener);
    }

    @Override
    public void removeListener(MapChangeListener<? super String, ? super Object> mapChangeListener) {
        this.mapChangeListeners.remove(mapChangeListener);
    }

    @Override
    public <T> Optional<T> getValue(String string, Class<T> clazz) {
        Objects.requireNonNull(string, "key cannot be null");
        Objects.requireNonNull(clazz, "type cannot be null");
        Class<?> clazz2 = this.platformKeys.get(string);
        Object object = this.effectivePreferences.get(string);
        if (clazz2 == null) {
            if (object != null) {
                if (clazz.isInstance(object)) {
                    Object object2 = object;
                    return Optional.of(object2);
                }
                throw new IllegalArgumentException("Incompatible types: requested = " + clazz.getName() + ", actual = " + object.getClass().getName());
            }
            return Optional.empty();
        }
        if (!this.isConvertible(clazz2, clazz)) {
            throw new IllegalArgumentException("Incompatible types: requested = " + clazz.getName() + ", actual = " + clazz2.getName());
        }
        if (object == null) {
            return Optional.empty();
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Incompatible types: requested = " + clazz.getName() + ", actual = " + object.getClass().getName());
        }
        Object object3 = object;
        return Optional.of(object3);
    }

    @Override
    public Optional<Integer> getInteger(String string) {
        return this.getValue(string, Integer.class);
    }

    @Override
    public Optional<Double> getDouble(String string) {
        return this.getValue(string, Double.class);
    }

    @Override
    public Optional<Boolean> getBoolean(String string) {
        return this.getValue(string, Boolean.class);
    }

    @Override
    public Optional<String> getString(String string) {
        return this.getValue(string, String.class);
    }

    @Override
    public Optional<Color> getColor(String string) {
        return this.getValue(string, Color.class);
    }

    @Override
    public ReadOnlyBooleanProperty reducedMotionProperty() {
        return this.properties.reducedMotionProperty();
    }

    @Override
    public boolean isReducedMotion() {
        return this.properties.isReducedMotion();
    }

    @Override
    public ReadOnlyBooleanProperty reducedTransparencyProperty() {
        return this.properties.reducedTransparencyProperty();
    }

    @Override
    public boolean isReducedTransparency() {
        return this.properties.isReducedTransparency();
    }

    @Override
    public ReadOnlyBooleanProperty reducedDataProperty() {
        return this.properties.reducedDataProperty();
    }

    @Override
    public boolean isReducedData() {
        return this.properties.isReducedData();
    }

    @Override
    public ReadOnlyBooleanProperty persistentScrollBarsProperty() {
        return this.properties.persistentScrollBarsProperty();
    }

    @Override
    public boolean isPersistentScrollBars() {
        return this.properties.isPersistentScrollBars();
    }

    @Override
    public ReadOnlyObjectProperty<ColorScheme> colorSchemeProperty() {
        return this.properties.colorSchemeProperty();
    }

    @Override
    public ColorScheme getColorScheme() {
        return this.properties.getColorScheme();
    }

    @Override
    public ReadOnlyObjectProperty<Color> backgroundColorProperty() {
        return this.properties.backgroundColorProperty();
    }

    @Override
    public Color getBackgroundColor() {
        return this.properties.getBackgroundColor();
    }

    @Override
    public ReadOnlyObjectProperty<Color> foregroundColorProperty() {
        return this.properties.foregroundColorProperty();
    }

    @Override
    public Color getForegroundColor() {
        return this.properties.getForegroundColor();
    }

    @Override
    public ReadOnlyObjectProperty<Color> accentColorProperty() {
        return this.properties.accentColorProperty();
    }

    @Override
    public Color getAccentColor() {
        return this.properties.getAccentColor();
    }

    public void update(Map<String, Object> map) {
        Map<String, Object> map2 = Map.copyOf(this.effectivePreferences);
        this.effectivePreferences.putAll(map);
        Map<String, ChangedValue> map3 = ChangedValue.getEffectiveChanges(map2, this.effectivePreferences);
        this.effectivePreferences.entrySet().removeIf(entry -> entry.getValue() == null);
        if (!map3.isEmpty()) {
            this.properties.update(map3, this.platformKeyMappings);
            this.fireValueChangedEvent(map3);
        }
    }

    private void fireValueChangedEvent(Map<String, ChangedValue> map) {
        this.invalidationListeners.forEach((? super T invalidationListener) -> invalidationListener.invalidated(this));
        MapExpressionHelper.SimpleChange<String, Object> simpleChange = new MapExpressionHelper.SimpleChange<String, Object>(this);
        for (Map.Entry<String, ChangedValue> entry : map.entrySet()) {
            Object object = entry.getValue().oldValue();
            Object object2 = entry.getValue().newValue();
            if (object == null && object2 != null) {
                simpleChange.setAdded(entry.getKey(), object2);
            } else if (object != null && object2 == null) {
                simpleChange.setRemoved(entry.getKey(), object);
            } else {
                simpleChange.setPut(entry.getKey(), object, object2);
            }
            for (MapChangeListener<? super String, Object> mapChangeListener : this.mapChangeListeners) {
                mapChangeListener.onChanged(simpleChange);
            }
        }
    }

    private boolean isConvertible(Class<?> clazz, Class<?> clazz2) {
        if (clazz.isArray()) {
            return this.isArrayConvertible(clazz, clazz2);
        }
        if (clazz.isInterface()) {
            return this.isInterfaceConvertible(clazz, clazz2);
        }
        return this.isClassConvertible(clazz, clazz2);
    }

    private boolean isClassConvertible(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isInterface()) {
            return !Modifier.isFinal(clazz.getModifiers()) || clazz2.isAssignableFrom(clazz);
        }
        if (clazz2.isArray()) {
            return clazz == Object.class;
        }
        return clazz2.isAssignableFrom(clazz) || clazz.isAssignableFrom(clazz2);
    }

    private boolean isInterfaceConvertible(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isArray()) {
            return clazz == Serializable.class || clazz == Cloneable.class;
        }
        if (!Modifier.isFinal(clazz2.getModifiers())) {
            return true;
        }
        return clazz.isAssignableFrom(clazz2);
    }

    private boolean isArrayConvertible(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isInterface()) {
            return clazz2 == Serializable.class || clazz2 == Cloneable.class;
        }
        if (clazz2.isArray()) {
            Class<?> clazz3 = clazz.getComponentType();
            Class<?> clazz4 = clazz2.getComponentType();
            if (clazz3.isPrimitive() && clazz4.isPrimitive()) {
                return clazz3 == clazz4;
            }
            if (!clazz3.isPrimitive() && !clazz4.isPrimitive()) {
                return this.isConvertible(clazz3, clazz4);
            }
            return false;
        }
        return clazz2 == Object.class;
    }
}

